function [fitresult, gof] = Create_Surface_Fit_2(X, Y, Z, starting_vals)
%CREATESURFACEFIT(X,Y,Z)
%  Fit surface to data.
%
%  Input Data:
%      X Input : X
%      Y Input : Y
%      Z output: Z
%      Weights : (none)
%
%  Output:
%      fitresult : an sfit object representing the fit.
%      gof : structure with goodness-of fit info.
%
%  See also FIT, SFIT.
global opts;
global ft;

%% Create Surface Fit

ft = fittype( '(bottom1 + (top1 - bottom1) / (1+10^((LogEC50_1 - x)*HillSlope1))) * (bottom2 + (top2 - bottom2) / (1+10^((LogEC50_2 - y)*HillSlope2)))', 'indep', {'x', 'y'}, 'depend', 'z');
opts = fitoptions( ft);
opts.Display = 'off';
opts.Lower   = [-Inf -Inf -Inf -Inf -Inf -Inf -Inf -Inf];
opts.Upper   = [Inf Inf Inf Inf Inf Inf Inf Inf];
opts.Weights = zeros(1,0);
%opts.StartPoint = [0.345565927376724 0.511142979027213 0.527232849483832 0.521533398083447 0.284479172477811 0.951406258730611];
%opts.StartPoint = [0.902694718955865 0.349082013525347 0.406954370962453 0.593423889585684 0.0507528367679441 0.410812148496715];
opts.StartPoint = starting_vals;
[fitresult, gof] = fit( [X, Y], Z, ft, opts );

% Plot fit with data.
figure( 'Name', 'Plux_CI surface function fit (log)' );
h = plot( fitresult, [X, Y], Z );
%set(gca,'XScale','log');
%set(gca,'YScale','log');
%set(gca,'ZScale','log');

% Plot fit with data.
grid on
% Label axes
xlabel( 'AHL (log)' );
ylabel( 'CI (log)');
zlabel( 'betagal (log)' );
legend( h, 'Plux_CI', 'betgal vs. AHL, CI', 'Location', 'NorthEast' );